/*
 * UncheckedException.java
 *
 * Created on November 30, 2005, 11:59 PM
 */

package notorrent.util;

import java.io.*;

/**
 * I copied this from<BR>
 * <a href="http://www.mindview.net/Etc/Discussions/CheckedExceptions">http://www.mindview.net/Etc/Discussions/CheckedExceptions</a><BR>
 * It's called ExceptionAdapter there, but I renamed it to
 * UncheckedException, because I think that's a more appropriate name.
 *
 * On that webpage, Bruce Eckel explains why he thinks checked exceptions
 * are a bad idea.  I agree with him.  After writing a whole bunch of code
 * and then compiling (I know it's better to code a little bit at a time,
 * but I didn't in this case), I found that all of my errors had to do with
 * uncaught exceptions.  After changing some code to propagate the exceptions
 * and some other code to swallow the exceptions, I remembered that I had
 * read the aforementioned article several months prior.  When I re-read the
 * article just now, I decided to use mainly unchecked exceptions in my code.
 *
 * Now, instead of swallowing exceptions to avoid the hassle of propagating 
 * them at each level, I rethrow the exception as an UncheckedException
 * when it first shows up.
 */
public class UncheckedException extends RuntimeException
{
    private final String stackTrace;
    public Exception originalException;
    
    public UncheckedException(Exception e)
    {
	super(e.toString());
	originalException = e;
	StringWriter sw = new StringWriter();
	e.printStackTrace(new PrintWriter(sw));
	stackTrace = sw.toString();
    }
    
    public void printStackTrace()
    {
	printStackTrace(System.err);
    }
    
    public void printStackTrace(java.io.PrintStream s)
    {
	synchronized(s)
	{
	    s.print(getClass().getName() + ": ");
	    s.print(stackTrace);
	}
    }
    
    public void printStackTrace(java.io.PrintWriter s)
    {
	synchronized(s)
	{
	    s.print(getClass().getName() + ": ");
	    s.print(stackTrace);
	}
    }
    
    public void rethrow() throws Exception
    {
	throw originalException; 
    }
}
