/*
 * Tracker.java
 *
 */

package notorrent.tracker;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import notorrent.util.MethodNotImplementedException;
import notorrent.util.UncheckedException;

/**
 *
 * @author Howie
 *
 * The main class for the tracker.  Contains the main method, which
 * starts the tracker.
 */
public class Tracker
{
    private CommandLineArgs commandLineArgs;
    private ServerSocket serverSocket = null;
    
    /** Creates a new instance of Tracker */
    public Tracker()
    {
	commandLineArgs   = new CommandLineArgs();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args)
    {
	Tracker tracker = new Tracker();
	tracker.run(args);
    }
    
    /**
     * main tracker body.  making this method separate from main lets me get rid
     * of the static context.
     */
    private void run(String[] args)
    {
	parseCommandLineArgs(args);
	initializeStateInfo();
	startServerSocket();
	spawnHandlerThreads();	
    }
    
    /**
     * sets tracker settings based on command line arguments.
     */
    private void parseCommandLineArgs(String[] args)
    {
	commandLineArgs.parseCommandLineArgs(args);
    }
    
    /**
     * initializes data structures holding info on peer list and
     * on which peers hold copies of which resources.
     */
    private void initializeStateInfo()
    {
	StateInfo.initialize(commandLineArgs);
    }
    
    private void startServerSocket()
    {
	try
	{
	    serverSocket = new ServerSocket(commandLineArgs.getPortToListenOn());
	    int serverPort = serverSocket.getLocalPort();
//	    String serverAddress = serverSocket.getInetAddress().getHostAddress();
	    String serverAddress = InetAddress.getLocalHost().getHostAddress();
	    System.out.println("Tracker will listen for connections on port " + serverPort + " at address " + serverAddress + ".");
	}
	catch (IOException e)
	{
	    throw new UncheckedException(e);
	}
    }
    
    /**
     * we handle client connections by creating a pool of threads.
     * each thread is responsible for listening for connections,
     * handling any connection that comes in, and then listening for
     * connections again.
     */
    private void spawnHandlerThreads()
    {
	// dispatch numThreads HandlerThreads
	for (int i = 0; i < commandLineArgs.getNumThreads(); i++)
	{
	    Runnable handlerThread = new TrackerThread(serverSocket);
	    new Thread(handlerThread).start();
	}
    }
}
