/*
 * ResourceInfo.java
 *
 * Created on December 13, 2005, 2:17 AM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package notorrent.tracker;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;

/**
 * maintains info about a resource including:
 * which peers claim to hold that resource and
 * how many times the resource has been requested recently.
 * @author hrv2101
 */
public class ResourceInfo
{
//    private URI resourceURI;
    private Set<Peer> peersWithResource;
    private int creationTime;
    private int[] numRequests;
    
    /** Creates a new instance of ResourceInfo */
    public ResourceInfo() // URI resourceURI, 
    {
//	this.resourceURI	 = resourceURI;
	this.peersWithResource   = new HashSet<Peer>();
	this.creationTime	 = StateInfo.currentTime();
	this.numRequests	 = new int[StateInfo.getNumTimeWindows()];
		
	// -1 indicates that the time window has not been used yet
	for (int i = 0; i < numRequests.length; i++)
	{
	    numRequests[i] = -1;
	}
    }
    
    public Set<Peer> getPeersWithResource()
    {
	return peersWithResource;
    }
    
    /**
     * adds peerToAdd to Set of Peers that claim to have the resource.
     */
    public void addPeer(Peer peerToAdd)
    {
	this.peersWithResource.add(peerToAdd);
    }
    
    public void updateRequestCounter()
    {
	// TODO
    }
    
    /**
     * removes the peer from the Set of Peers if it is in the Set.  
     * if the peer was not int the set, we still don't complain.
     */
    public void evictPeer(Peer peer)
    {
        peersWithResource.remove(peer);
    }
    
//    public boolean equals(Object obj)
//    {
//	if (this == obj)
//	{
//	    return true;
//	}
//	
//	if (!(obj instanceof ResourceInfo))
//	{
//	    return false;
//	}
//	
//	// two ResourceInfo objects are considered equal if they have the same resourceURI
//	ResourceInfo that = (ResourceInfo)obj;
//	return this.resourceURI.equals(that.resourceURI);
//    }
}
