/*
 * MessageResourceRequest.java
 *
 */

package notorrent.messages;

import java.net.URI;
import java.net.URISyntaxException;
import notorrent.util.UncheckedException;
import org.jdom.Element;

/**
 *
 * @author Howie
 */
public class MessageResourceRequest extends Message
{
    private static final String REQUESTED_RESOURCE_TAG	    = "requestedResource";
    
    /** whether this message has been populated with values */
    private boolean messagePopulated	= false;
    
    private URI requestedResource	= null;
    
    public URI getRequestedResource()
    {
	return requestedResource;
    }
    
    /**
     * the messageContentsElement is an XML node containing this message's
     * fields (encoded in XML of course).
     */
    public MessageResourceRequest(Element messageContentsElement)
    {
	decode(messageContentsElement);
    }
    
    public MessageResourceRequest(URI requestedResource)
    {
	this.requestedResource	    = requestedResource;
	
	this.messagePopulated	    = true;
    }
    
    public MessageResourceRequest(String requestedResource)
    {
	try
	{
	    this.requestedResource	= new URI(requestedResource);
	    
	    this.messagePopulated	= true;
	}
	catch (java.net.URISyntaxException e)
	{
	    throw new UncheckedException(e);
	}
    }
    
    public Message handle()
    {
	if (!messagePopulated)
	    throw new MessageNotPopulatedException();
	
	System.out.println("in MessageResourceRequest.handle().  nothing to do.  no response message will be sent.");
	
	return null;
    }
    
    XMLEncodedMessage encodeAsXML()
    {
	XMLEncodedMessage encodedMessage = new XMLEncodedMessage(MessageType.RESOURCE_REQUEST);
	
	encodedMessage.addField(REQUESTED_RESOURCE_TAG, requestedResource.toString());
	
	return encodedMessage;
    }
    
    /**
     * set this message's fields based on the subnodes of the given
     * messageContentsElement.
     */
    private void decode(Element messageContentsElement)
    {
	try
	{
	    String requestedResourceString 	= messageContentsElement.getChildTextTrim(REQUESTED_RESOURCE_TAG);
	    
	    if (requestedResourceString == null)
	    {
		throw new MalformedMessageException("a required field tag is missing");
	    }
	    
	    requestedResource	    = new URI(requestedResourceString);
	    
	    this.messagePopulated   = true;
	}
	catch (URISyntaxException e)
	{
	    throw new UncheckedException(e);
	}
    }
}
