/*
 * MessagePeerListResponse.java
 *
 */

package notorrent.messages;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import notorrent.tracker.Peer;
import notorrent.util.UncheckedException;
import org.jdom.Element;

/**
 *
 * @author Howie
 */
public class MessagePeerListResponse extends Message
{
    private static final String TIMEOUT_TAG		= "timeout";
    private static final String PEERS_WITH_RESOURCE_TAG	= "peersWithResource";
    private static final String REQUESTED_RESOURCE_TAG	= "requestedResource";
    
    /** whether this message has been populated with values */
    private boolean messagePopulated	= false;

    /**
     * if a message is not received from client within timeout seconds,
     * client will be dropped from peer list
     */
    private int timeout = -1;
    
    public int getTimeout()
    {
	return timeout;
    }
    
    /**
     * peers purporting to have a copy of the resource
     */
    private Set<Peer> peersWithResource = null;
    
    public Set<Peer> getPeersWithResource()
    {
	return peersWithResource;
    }
    
    public List<Peer> getPeersWithResourceList()
    {
	return new ArrayList<Peer>(peersWithResource);
    }
    
    private URI requestedResource = null;
    
    public URI getRequestedResource()
    {
	return requestedResource;
    }    

    /**
     * the messageContentsElement is an XML node containing this message's
     * fields (encoded in XML of course).
     */
    public MessagePeerListResponse(Element messageContentsElement)
    {
	decode(messageContentsElement);
    }
       
    public MessagePeerListResponse(
	    int timeout,
	    Set<Peer> peersWithResource,
	    URI requestedResource)
    {
	this.timeout		= timeout;
	this.peersWithResource	= peersWithResource;
	this.requestedResource	= requestedResource;
	
	this.messagePopulated	    = true;
    }
        
    public Message handle()
    {
	if (!messagePopulated)
	    throw new MessageNotPopulatedException();
	
//	List<Peer> peersWithResource = StateInfo.getPeersWithResource(requestedResource);
	
//	MessagePeerListResponse response = new MessagePeerListResponse(timeout(), peersWithResource, requestedResource);
	
//	return response.encode();
	
	System.out.println("in MessagePeerListResponse.handle().  currently doing nothing.");
	
	return null;
    }    
    
    XMLEncodedMessage encodeAsXML()
    {
	XMLEncodedMessage encodedMessage = new XMLEncodedMessage(MessageType.PEER_LIST_RESPONSE);
	
	encodedMessage.addField(TIMEOUT_TAG, Integer.toString(timeout));
	encodedMessage.addField(Peer.peersSetAsElement(PEERS_WITH_RESOURCE_TAG, peersWithResource));
	encodedMessage.addField(REQUESTED_RESOURCE_TAG, requestedResource.toString());
	
	return encodedMessage;
    }

    /**
     * set this message's fields based on the subnodes of the given
     * messageContentsElement.
     */
    private void decode(Element messageContentsElement)
    {
	try
	{
	    String timeoutString	    = messageContentsElement.getChildTextTrim(TIMEOUT_TAG);
	    Element peersSetElement	    = messageContentsElement.getChild(PEERS_WITH_RESOURCE_TAG);
	    String requestedResourceString  = messageContentsElement.getChildTextTrim(REQUESTED_RESOURCE_TAG);
	    
	    if (timeoutString == null ||
		    peersSetElement == null ||
		    requestedResourceString == null)
	    {
		throw new MalformedMessageException("a required field tag is missing");
	    }
	    
	    timeout		= Integer.parseInt(timeoutString);
	    peersWithResource	= Peer.elementAsPeersSet(peersSetElement);
	    requestedResource	= new URI(requestedResourceString);
	    
	    this.messagePopulated   = true;
	}
	catch (URISyntaxException e)
	{
	    throw new UncheckedException(e);
	}
    }
}
