/*
 * MessageError.java
 *
 * Created on December 1, 2005, 2:34 AM
 */

package notorrent.messages;

import org.jdom.Element;

/**
 *
 * @author Howie
 */
public class MessageError extends Message
{
    private static final String ERROR_MESSAGE_TAG = "errorMessage";
    
    /** whether this message has been populated with values */
    private boolean messagePopulated	= false;
    
    private String errorMessage		= null;
    
    /**
     * the messageContentsElement is an XML node containing this message's
     * fields (encoded in XML of course).
     */
    public MessageError(Element messageContentsElement)
    {
	decode(messageContentsElement);
    }
    
    public MessageError(String errorMessage)
    {
	this.errorMessage	= errorMessage;
	
	this.messagePopulated	= true;
    }
    
    /**
     * prints the error message.
     * no response message is returned. (actually, it's a null)
     */
    public Message handle()
    {
	if (!messagePopulated)
	    throw new MessageNotPopulatedException();
	
	System.out.println("error message: " + errorMessage);
	
	return null;	// no response message to send
    }
    
    XMLEncodedMessage encodeAsXML()
    {
	XMLEncodedMessage encodedMessage = new XMLEncodedMessage(MessageType.ERROR);
	
	encodedMessage.addField(ERROR_MESSAGE_TAG, errorMessage);
	
	return encodedMessage;
    }
    
    /**
     * set this message's fields based on the subnodes of the given
     * messageContentsElement.
     */
    private void decode(Element messageContentsElement)
    {
	errorMessage = messageContentsElement.getChildTextTrim(ERROR_MESSAGE_TAG);
	
	if (errorMessage == null)
	{
	    throw new MalformedMessageException("a required field tag is missing");
	}
	
	this.messagePopulated   = true;
    }
}
