/*
 * ClientRequest.java
 *
 */

package notorrent.client;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import notorrent.messages.Message;
import notorrent.messages.MessagePeerListRequest;
import notorrent.messages.MessagePeerListResponse;

/**
 *
 * @author Howie
 */
public class ClientRequest implements Runnable
{
    /** to keep track of the separate handler threads */
    private static int nextThreadId	= 0;
    private int threadId		= -1;
    
    /**
     * Creates a new instance of ClientRequest
     */
    public ClientRequest()
    {
	this.threadId = nextThreadId++;
    }
    
    public static void main(String[] args)
    {
	spawnThreads();
	
    }
    
    public void run()
    {
	try
	{
	    System.out.println("client thread #" + threadId);
	    String urlToGet = "http://foo/";
	    String serverAddy = "localhost";
	    int serverPort = 4242;
	    int portToListenForPeers = 4200;
	    
	    Message peerListRequestMessage = new MessagePeerListRequest(urlToGet);
	    //	System.out.println(".getMyAddress():" + ((MessagePeerListRequest)peerListRequestMessage).getMyAddress().toString());
	    //	System.out.println("InetAddress.getLocalHost():" + InetAddress.getLocalHost().toString());
	    
	    System.out.println("Message to be sent:\n" + peerListRequestMessage);
	    
	    
	    // connect to server
	    Socket socket = new Socket(serverAddy, serverPort);
	    System.out.println("Connected to server...sending PeerListRequest message");
	    
	    BufferedOutputStream outputStream = new BufferedOutputStream(socket.getOutputStream());
	    
	    
	    // send the encoded message to the server
	    outputStream.write(peerListRequestMessage.encode());
	    outputStream.flush();
	    
	    // closing of output stream indicates end of message
	    //	outputStream.close();
	    socket.shutdownOutput();
	    
	    InputStream inputStream = socket.getInputStream();
	    
	    
	    // receive response message
	    //	MessagePeerListResponse peerListResponseMessage = (MessagePeerListResponse)Message.decode(inputStream);
	    //	socket.close();
	    //	System.out.println("Message received:\n" + peerListResponseMessage);
	    
	    System.out.println("waiting for magic...");
	    
	    int BUFSIZE = 32;
	    int recvMsgSize;
	    byte[] byteBuffer = new byte[BUFSIZE];
	    
	    ByteArrayOutputStream baos = new ByteArrayOutputStream();
	    
	    while ((recvMsgSize = inputStream.read(byteBuffer)) != -1)
	    {
		baos.write(byteBuffer, 0,  recvMsgSize);
	    }
	    
	    byte[] receivedMessageAsBytes = baos.toByteArray();
	    Message receivedMessage = Message.decode(receivedMessageAsBytes);
	    
	    
	    //	Message responseMessage = Message.decode(inputStream);
	    socket.close();
	    System.out.println("Message received:\n" + receivedMessage + "\n");
	    
	    //	int timeout = peerListResponseMessage.getTimeout();
	    //	URI requestedResource = peerListResponseMessage.getRequestedResource();
	}
	catch (IOException e)
	{
	    e.printStackTrace();
	}
    }
    
    private static void spawnThreads()
    {
	// dispatch numThreads HandlerThreads
	for (int i = 0; i < 10; i++)
	{
	    Runnable thread = new ClientRequest();
	    new Thread(thread).start();
	}
    }
    
}
