/*
 * ClientCache.java
 *
 */

package notorrent.client;

import java.net.URI;
import java.util.Hashtable;
import notorrent.util.Constants;

/**
 *
 * @author hrv2101
 */
public class ClientCache
{
    private static ClientCache clientCache = null;
    
    private Hashtable<URI, byte[]> cachedResources = null;
    
    /** Creates a new instance of ClientCache */
    public ClientCache()
    {
	this.cachedResources = new Hashtable<URI, byte[]>();
    }
    
    public static void initialize()
    {
	clientCache = new ClientCache();
    }
    
    /**
     * stores the given resource in the cachedResources table.
     * if the resource was already in the cachedResources table, it will be replaced.
     *
     * if the resource was not in the cachedResources table, it will be added.
     *
     * returns true if a resource for the requestedUri was already in the cache.
     * returns false if a resource for the requestedUri was not already in the cache.
     */
    public static synchronized boolean cacheRetrievedResource(byte[] retrievedResource, URI requestedUri)
    {
	// Hashtable.put returns the previous value for the given key, or null if there was no previous value
	byte[] resourceAlreadyInCache = clientCache.cachedResources.put(requestedUri, retrievedResource);
	
	return resourceAlreadyInCache != null;
    }

    /**
     * if the requested resource is in the cache, it is returned.
     * if not, null is returned.
     */
    public static synchronized byte[] requestResourceFromCache(URI requestedUri)
    {
	byte[] cachedResource = clientCache.cachedResources.get(requestedUri);
		
        // will be null if the resource wasn't in the cache
	return cachedResource;
    }
}
