/*
 * BrowsersResourceRequest.java
 *
 */
package notorrent.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import notorrent.util.UncheckedException;
import notorrent.util.Debug;

/**
 *
 * @author hrv2101
 */
public class BrowsersResourceRequest
{
//    private URI requestedUri = null;
//
    public URI getURI() throws URISyntaxException
    {
	return new URI(requestedUriString);
    }
//
//    private void setURI(URI uri)
//    {
//	this.requestedUri = uri;
//    }
    
    private String requestedUriString = null;
    
    /**
     * returns the String we tried to use to create a URI.
     * this is useful for debugging in case
     * requestedUri = new URI(requestedUriString);
     * throws a URISyntaxException (for containing an illegal character such as '|')
     */
    public String getURIString()
    {
	return requestedUriString;
    }
    
    private void setURIString(String uriString)
    {
	this.requestedUriString = uriString;
    }
    
    /** Creates a new instance of BrowsersResourceRequest */
    private BrowsersResourceRequest(String uriString)
    {
	this.requestedUriString = uriString;
    }
    
    public static BrowsersResourceRequest readUsersRequest(Socket browserSocket) throws URISyntaxException
    {
	try
	{
	    BufferedReader browserBufferedReader = new BufferedReader( new InputStreamReader(browserSocket.getInputStream()) );
	    
	    // read browser's request, which should look something like this:
	    // GET http://www.example.com/ HTTP/1.1
	    String browserRequest = browserBufferedReader.readLine();
	    
	    if (browserRequest == null)
	    {
		throw new NoRequestUriFoundException();
	    }
	    
	    System.out.println("----------------------------");
	    System.out.println("browser's HTTP request:");
	    System.out.println(browserRequest);
	    String requestLine;
	    while ((requestLine = browserBufferedReader.readLine()) != null)
	    {
		System.out.println(requestLine);
		
		// two consecutive newlines represents end of HTTP request
//		if (requestLine.contains("\n\n") ||
//			requestLine.contains("\r\n\r\n") ||
//			requestLine.contains("\r\r"))
//		{
//		    break;
//		}
		
		// but readLine removes terminating newlines, so we search for an empty string instead
		if (requestLine.equals(""))
		{
		    break;		
		}
	    }
	    System.out.println("----------------------------");
	    
	    // parse browserRequest.
	    // stored requestedUriString and requestedUri in ret
	    String uriString = parseBrowserRequestForUri(browserRequest);
	    
	    return new BrowsersResourceRequest(uriString);
	}
	catch (IOException e)
	{
	    throw new UncheckedException(e);
	}
    }
    
    /**
     * takes a browserRequest of the form:
     * GET http://www.example.com/ HTTP/1.1
     *
     * and returns requestedURIString
     */
    private static String parseBrowserRequestForUri(String browserRequest) throws URISyntaxException
    {
	Debug.printDebug("The browserRequest is: " + browserRequest);
	
	// form our regular expression to parse the browserRequest
	// browserRequest expected to look something like this:
	// GET http://www.example.com/ HTTP/1.1
	String regex = "\\w{3,7} (\\S+) HTTP/1.[01]"; // more specific matching of URL: [\\w/.:?]
	
	Debug.printDebug("regex:" + regex);
	
	Pattern p = Pattern.compile(regex);
	Matcher m = p.matcher(browserRequest);
	
	if ( !m.matches() )
	{
	    throw new URISyntaxException(browserRequest, "Error parsing the browserRequest for the requested URL.");
	}
	
	String uriString = m.group(1);
	
	Debug.printDebug("THE EXTRACTED URI IS: " + uriString);
	
	return uriString;
    }
}
